/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.neoforge;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCCreativeTabs;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.config.FeatureToggle;
import com.simibubi.create.Create;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CCCreativeTabsImpl
extends CCCreativeTabs {
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"copycats");
    public static final Supplier<CreativeModeTab> MAIN_TAB = TAB_REGISTER.register("main", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.copycats.main")).withTabsBefore(new ResourceLocation[]{Create.asResource((String)"palettes")}).icon(() -> CCBlocks.COPYCAT_SLAB.asStack()).displayItems((CreativeModeTab.DisplayItemsGenerator)new CCCreativeTabs.AdvancedDisplayGenerator(DECORATIVE, MAIN_TAB)).build());
    public static final Supplier<CreativeModeTab> FUNCTIONAL_TAB = TAB_REGISTER.register("functional", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.copycats.functional")).withTabsBefore(new ResourceLocation[]{Copycats.asResource("main")}).icon(() -> CCBlocks.COPYCAT_COGWHEEL.asStack()).displayItems((CreativeModeTab.DisplayItemsGenerator)new CCCreativeTabs.AdvancedDisplayGenerator(FUNCTIONAL, FUNCTIONAL_TAB)).build());

    public static void setCreativeTab() {
    }

    public static void register(IEventBus modEventBus) {
        TAB_REGISTER.register(modEventBus);
        modEventBus.addListener(CCCreativeTabsImpl::modifyTabEntries);
    }

    public static void modifyTabEntries(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab().getType() == CreativeModeTab.Type.SEARCH) {
            Set hiddenItems = Stream.concat(DECORATIVE.stream(), FUNCTIONAL.stream()).filter(x -> !FeatureToggle.isEnabled(x.getId())).map(ItemProviderEntry::asItem).collect(Collectors.toSet());
            event.getSearchEntries().forEach(itemStack -> {
                if (hiddenItems.contains(itemStack.getItem()) && event.getTab().contains(itemStack)) {
                    event.remove(itemStack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
                }
            });
        }
    }

    public static CreativeModeTab getBaseTab() {
        return MAIN_TAB.get();
    }

    public static ResourceKey<CreativeModeTab> getBaseTabKey() {
        return (ResourceKey)((Registry)TAB_REGISTER.getRegistry().get()).getResourceKey((Object)MAIN_TAB.get()).get();
    }

    public static CreativeModeTab getFunctionalTab() {
        return FUNCTIONAL_TAB.get();
    }

    public static ResourceKey<CreativeModeTab> getFunctionalTabKey() {
        return (ResourceKey)((Registry)TAB_REGISTER.getRegistry().get()).getResourceKey((Object)FUNCTIONAL_TAB.get()).get();
    }
}

